/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.b2c.api.cipher;

import com.hisun.b2c.api.cipher.Base64;
import com.hisun.b2c.api.cipher.SaveKeys;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSA {
    private static final String ALGORITHM = "RSA";
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    public static final String charset = "UTF-8";

    public static PublicKey getPublicKeyFromX509(String bysKey) throws NoSuchAlgorithmException, Exception {
        return (PublicKey)RSA.getPublicKeyFromX509(ALGORITHM, bysKey, true);
    }

    public static PrivateKey getPrivateKeyFromX509(String bysKey) throws NoSuchAlgorithmException, Exception {
        return (PrivateKey)RSA.getPublicKeyFromX509(ALGORITHM, bysKey, true);
    }

    public static Key getPublicKeyFromX509(String algorithm, String bysKey, boolean isPubKey) throws NoSuchAlgorithmException, Exception {
        byte[] decodedKey = Base64.decode(bysKey);
        X509EncodedKeySpec x509 = new X509EncodedKeySpec(decodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        if (isPubKey) {
            return keyFactory.generatePublic(x509);
        }
        return keyFactory.generatePrivate(x509);
    }

    public static String encrypt(String content, String key) {
        try {
            PublicKey pubkey = RSA.getPublicKeyFromX509(key);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, pubkey);
            byte[] plaintext = content.getBytes(charset);
            byte[] output = cipher.doFinal(plaintext);
            String s = new String(Base64.encode(output));
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encrypt(String plainText, Key key) throws Exception {
        if (plainText == null) {
            return null;
        }
        byte[] input = plainText.getBytes();
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, key);
            return Base64.encode(cipher.doFinal(input));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String decrypt(String cipherText, Key key) throws Exception {
        if (cipherText == null) {
            return null;
        }
        if (key == null) {
            return null;
        }
        byte[] input = Base64.decode(cipherText);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, key);
            return new String(cipher.doFinal(input));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static SaveKeys createPairKey(SaveKeys saveKeys) {
        try {
            if (saveKeys == null) {
                saveKeys = new SaveKeys();
            }
            KeyPairGenerator keygen = KeyPairGenerator.getInstance(ALGORITHM);
            SecureRandom random = new SecureRandom();
            random.setSeed(1000L);
            keygen.initialize(1024, random);
            KeyPair keys = keygen.generateKeyPair();
            RSAPublicKey pubkey = (RSAPublicKey)keys.getPublic();
            saveKeys.setPublicKey(pubkey);
            String pubkeyText = Base64.encode(pubkey.getEncoded());
            saveKeys.setPublicKeyText(pubkeyText);
            RSAPrivateKey prikey = (RSAPrivateKey)keys.getPrivate();
            saveKeys.setPrivateKey(prikey);
            String prikeyText = Base64.encode(prikey.getEncoded());
            saveKeys.setPrivateKeyText(prikeyText);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return saveKeys;
    }

    public static String genMessageDigest(String plainText, String algorithm) throws Exception {
        if (plainText == null) {
            return null;
        }
        byte[] input = plainText.getBytes();
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(input);
        return RSA.byte2hex(md.digest());
    }

    public static String sign(String content, String privateKey) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decode(privateKey));
            KeyFactory keyf = KeyFactory.getInstance(ALGORITHM);
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(charset));
            byte[] signed = signature.sign();
            return Base64.encode(signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean doCheck(String content, String sign, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            byte[] encodedKey = Base64.decode(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(charset));
            boolean bverify = signature.verify(Base64.decode(sign));
            return bverify;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? String.valueOf(hs) + "0" + stmp : String.valueOf(hs) + stmp;
            ++n;
        }
        return hs.toUpperCase();
    }
}

