/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.b2c.api.core;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import com.hisun.b2c.api.core.IPOSUtils;
import com.hisun.b2c.api.util.IPOSHelper;
import java.io.IOException;

public abstract class IPOSBase {
    public static final String INSTALL_TEMP_APK_NAME = "/temp.apk";
    public static final int WHAT_SHOW_PROGRESS = 401;
    public static final int WHAT_CLOSE_PROGRESS = 402;
    public static final int WHAT_SHOW_INSTALL = 403;
    public static final int WHAT_SHOW_PROGRESS_CAN_CANCEL = 404;
    private Context context;
    private ProgressDialog mProgress;
    protected String tagName;
    protected IPOSUtils iposUtils;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 401) {
                String[] infos = (String[])msg.obj;
                IPOSBase.this.mProgress = IPOSHelper.showProgress(IPOSBase.this.context, infos[0], infos[1], true, false);
            } else if (msg.what == 402) {
                IPOSBase.this.closeProgress();
            } else if (msg.what == 403) {
                IPOSBase.this.closeProgress();
                String path = (String)msg.obj;
                IPOSBase.this.showInstallConfirmDialog(path);
            } else if (msg.what == 404) {
                Object[] infos = (Object[])msg.obj;
                IPOSBase.this.mProgress = IPOSHelper.showProgress(IPOSBase.this.context, (String)infos[0], (String)infos[1], true, true, (DialogInterface.OnCancelListener)infos[2]);
            }
        }
    };

    public IPOSBase(Context context) {
        this.context = context;
    }

    protected abstract String getTag();

    protected String getIPosReleaseName() {
        return "ipos_ii.apk";
    }

    private void chmod(String path) {
        try {
            String command = "chmod 777 " + path;
            Runtime runtime = Runtime.getRuntime();
            runtime.exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showInstallConfirmDialog(final String cachePath) {
        AlertDialog.Builder tDialog = new AlertDialog.Builder(this.getContext());
        tDialog.setTitle((CharSequence)"\u5b89\u88c5\u63d0\u793a").setMessage((CharSequence)"\u4e3a\u4e86\u4fdd\u8bc1\u60a8\u7684\u4ea4\u6613\u5b89\u5168\uff0c\u9700\u8981\u60a8\u5b89\u88c5\u624b\u673a\u5b89\u5168\u652f\u4ed8\u7ec4\u4ef6\uff0c\u624d\u80fd\u8fdb\u884c\u4ed8\u6b3e\u3002\n\u70b9\u51fb\u786e\u5b9a\uff0c\u7acb\u5373\u5b89\u88c5\u3002");
        tDialog.setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                IPOSBase.this.chmod(cachePath);
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.addFlags(0x10000000);
                intent.setDataAndType(Uri.parse((String)("file://" + cachePath)), "application/vnd.android.package-archive");
                IPOSBase.this.getContext().startActivity(intent);
            }
        });
        tDialog.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                IPOSBase.this.iposUtils.cancel();
            }
        });
        tDialog.setCancelable(false);
        tDialog.show();
    }

    protected void sendMessage(int what) {
        this.sendMessage(what, null, this.handler);
    }

    protected void sendMessage(int what, Object obj) {
        this.sendMessage(what, obj, this.handler);
    }

    protected void sendMessage(int what, Object obj, Handler handler) {
        Message msg = new Message();
        msg.what = what;
        msg.obj = obj;
        handler.sendMessage(msg);
    }

    protected void closeProgress() {
        try {
            if (this.mProgress != null) {
                this.mProgress.dismiss();
                this.mProgress = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Context getContext() {
        return this.context;
    }
}

