/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.b2c.api.core;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.hisun.b2c.api.IRemoteService;
import com.hisun.b2c.api.IRemoteServiceCallback;
import com.hisun.b2c.api.core.IPOSBase;

public class IPOSBinder
extends IPOSBase {
    private Integer lock = 0;
    private boolean mIsBound;
    private IRemoteService mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            Integer n = IPOSBinder.this.lock;
            synchronized (n) {
                IPOSBinder.this.mService = IRemoteService.Stub.asInterface(service);
                IPOSBinder.this.lock.notify();
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            IPOSBinder.this.mService = null;
        }
    };
    private IRemoteServiceCallback mCallback = new IRemoteServiceCallback.Stub(){

        @Override
        public void valueChanged(int value) {
        }

        @Override
        public void startActivity(String packageName, String className, int callingPid, Bundle bundle) throws RemoteException {
            Intent intent = new Intent("android.intent.action.MAIN");
            if (bundle == null) {
                bundle = new Bundle();
            }
            try {
                bundle.putInt("CallingPid", callingPid);
                intent.putExtras(bundle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IPOSBinder.this.closeProgress();
                }
            }).start();
            intent.setClassName(packageName, className);
            ((Activity)IPOSBinder.this.getContext()).startActivityForResult(intent, 619067);
        }
    };

    public IPOSBinder(Context context) {
        super(context);
        this.tagName = IPOSBinder.class.getName();
    }

    public void bindAndPay(final String order, final int myWhat, final Handler callback) {
        this.sendMessage(401, new String[]{"\u63d0\u793a", "\u6b63\u5728\u53d1\u9001\u652f\u4ed8\u8bf7\u6c42,\u8bf7\u7a0d\u4faf..."});
        this.bind();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String result = null;
                try {
                    try {
                        Integer n = IPOSBinder.this.lock;
                        synchronized (n) {
                            while (IPOSBinder.this.mService == null) {
                                IPOSBinder.this.lock.wait();
                            }
                        }
                        try {
                            IPOSBinder.this.mService.registerCallback(IPOSBinder.this.mCallback);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                        result = IPOSBinder.this.mService.IPay(order);
                        IPOSBinder.this.unbind();
                        IPOSBinder.this.sendMessage(myWhat, result, callback);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                        Log.e((String)IPOSBinder.this.getTag(), (String)e.toString());
                        IPOSBinder.this.mService = null;
                        IPOSBinder.this.closeProgress();
                    }
                }
                finally {
                    IPOSBinder.this.mService = null;
                    IPOSBinder.this.closeProgress();
                }
            }
        }).start();
    }

    public void bind() {
        String name = IRemoteService.class.getName();
        this.getContext().bindService(new Intent(name), this.mConnection, 1);
        this.mIsBound = true;
    }

    public void unbind() {
        if (this.mIsBound) {
            try {
                if (this.mService != null) {
                    try {
                        this.mService.unregisterCallback(this.mCallback);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
                this.getContext().unbindService(this.mConnection);
                this.mIsBound = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onDestroy() {
        this.unbind();
    }

    @Override
    protected String getTag() {
        return this.tagName;
    }
}

