/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.b2c.api.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.util.Log;
import com.hisun.b2c.api.core.IPOSBase;
import com.hisun.b2c.api.core.IPOSBinder;
import com.hisun.b2c.api.core.InstallReceiver;
import com.hisun.b2c.api.core.InstallReceiverListener;
import com.hisun.b2c.api.core.NetworkManager;
import com.hisun.b2c.api.util.IPOSHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class IPOSUtils
extends IPOSBase
implements InstallReceiverListener {
    private boolean iposIsInstalled = false;
    private boolean isCanceled = false;
    private InstallReceiver receiver;
    private IPOSBinder binder;
    private NetworkManager networkManager;
    private Handler handler;
    private boolean retrieveApkSuccessFlag = false;
    private File cacheDir;
    private String cachePath;
    private Runnable checkVersionRunnable = new Runnable(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                String newApkdlUrl = null;
                File cacheDir = IPOSUtils.this.getContext().getCacheDir();
                String cachePath = String.valueOf(cacheDir.getAbsolutePath()) + "/temp.apk";
                if (IPOSUtils.this.isCanceled) {
                    return;
                }
                if (IPOSUtils.this.retrieveApkSuccessFlag) {
                    PackageInfo apkInfo = IPOSUtils.this.getApkInfo(IPOSUtils.this.getContext(), cachePath);
                    System.out.println("old version:" + apkInfo.versionName);
                    newApkdlUrl = IPOSUtils.this.checkNewUpdate(apkInfo);
                } else {
                    System.out.println("no apk exist or retrieve failed, must download");
                    newApkdlUrl = IPOSUtils.this.checkNewUpdate(null);
                }
                if (IPOSUtils.this.isCanceled) {
                    return;
                }
                if (newApkdlUrl != null && newApkdlUrl.startsWith("NEWVERURL=")) {
                    newApkdlUrl = newApkdlUrl.subSequence("NEWVERURL=".length(), newApkdlUrl.length()).toString();
                    System.out.println("find download url[" + newApkdlUrl + "], bigin download");
                    IPOSUtils.this.networkManager.urlDownloadToFile(IPOSUtils.this.getContext(), newApkdlUrl, cachePath);
                    System.out.println("download done.");
                } else if (!IPOSUtils.this.retrieveApkSuccessFlag) {
                    System.out.println("can't find download url and retrieve failed. big error...");
                }
                if (IPOSUtils.this.isCanceled) {
                    return;
                }
                if (!new File(cachePath).exists()) {
                    IPOSUtils.this.sendMessage(402);
                    return;
                }
                IPOSUtils.this.sendMessage(403, cachePath);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                IPOSUtils.this.closeProgress();
            }
        }
    };
    private String orderForPay;
    private int whatForPay;

    public IPOSUtils(Context context) {
        super(context);
        this.tagName = IPOSUtils.class.getName();
        this.iposUtils = this;
        this.binder = new IPOSBinder(context);
        IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addDataScheme("package");
        this.receiver = new InstallReceiver();
        this.receiver.setIPOSUtilsListener(this);
        context.registerReceiver((BroadcastReceiver)this.receiver, filter);
    }

    @Override
    protected String getTag() {
        return this.tagName;
    }

    public synchronized void init() {
        this.iposIsInstalled = this.hasInstalled();
        this.cacheDir = this.getContext().getCacheDir();
        this.cachePath = String.valueOf(this.cacheDir.getAbsolutePath()) + "/temp.apk";
    }

    public synchronized void iPay(String order, int myWhat, Handler handler) throws Exception {
        this.handler = handler;
        this.whatForPay = myWhat;
        this.orderForPay = order;
        if (!this.iposIsInstalled) {
            this.retrieveApkSuccessFlag = this.retrieveApkFromAssets(this.getIPosReleaseName(), this.cachePath);
            if (this.retrieveApkSuccessFlag) {
                System.out.println("Pick up the ipos APK success.");
            } else {
                System.out.println("Pick up the ipos APK failed.");
            }
            this.sendMessage(404, new Object[]{"\u63d0\u793a", "\u6b63\u5728\u521d\u59cb\u5316\u5b89\u5168\u652f\u4ed8\u7ec4\u4ef6, \u5982\u679c\u662f\u7b2c\u4e00\u6b21\u4f7f\u7528,\u8be5\u8fc7\u7a0b\u53ef\u80fd\u6bd4\u8f83\u957f,\u8bf7\u8010\u5fc3\u7b49\u5f85...", new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    IPOSUtils.this.isCanceled = true;
                    if (IPOSUtils.this.networkManager != null) {
                        IPOSUtils.this.networkManager.cancel();
                    }
                    if (IPOSUtils.this.handler != null) {
                        IPOSUtils.this.handler.sendEmptyMessage(619068);
                    }
                }
            }});
            Thread t = new Thread(this.checkVersionRunnable);
            t.setDaemon(true);
            t.setPriority(5);
            t.start();
        } else {
            System.out.println("ipos is installed on device. ");
            File iposTemp = new File(this.cachePath);
            if (iposTemp.exists()) {
                iposTemp.delete();
            }
            this.iPay();
        }
    }

    public void iPay() throws Exception {
        if (this.orderForPay == null || !this.iposIsInstalled) {
            return;
        }
        this.binder.bindAndPay(this.orderForPay, this.whatForPay, this.handler);
        this.orderForPay = null;
    }

    private String checkNewUpdate(PackageInfo packageInfo) {
        String url = null;
        try {
            String requestUrl;
            String version;
            if (this.networkManager == null) {
                this.networkManager = new NetworkManager(this.getContext());
            }
            if (packageInfo != null) {
                version = packageInfo.versionName;
                requestUrl = IPOSHelper.getRequestUrl(version);
            } else {
                version = "0";
                requestUrl = IPOSHelper.getRequestUrl(version);
            }
            System.out.println("the check ver url is [" + requestUrl + "], version is [" + version + "]");
            url = this.networkManager.SendAndWaitResponse(requestUrl, version, "3", "TEMP_UA01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    private boolean hasInstalled() {
        return this.getPackageInfo() != null;
    }

    private PackageInfo getPackageInfo() {
        try {
            PackageManager manager = this.getContext().getPackageManager();
            List pkgList = manager.getInstalledPackages(0);
            int i = 0;
            while (i < pkgList.size()) {
                PackageInfo pI = (PackageInfo)pkgList.get(i);
                if (pI.packageName.equalsIgnoreCase("com.hisun.ipos2")) {
                    return pI;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Log.e((String)this.getTag(), (String)e.toString());
        }
        return null;
    }

    @Override
    public void notifyInstallState(boolean state) {
        this.iposIsInstalled = state;
        try {
            if (state) {
                this.iPay();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAPKFileExist() {
        File file = new File(this.getIPosReleaseName());
        return file.exists();
    }

    private PackageInfo getApkInfo(Context context, String archiveFilePath) {
        PackageManager pm = context.getPackageManager();
        PackageInfo apkInfo = pm.getPackageArchiveInfo(archiveFilePath, 128);
        return apkInfo;
    }

    private boolean retrieveApkFromAssets(String fileName, String path) {
        boolean bRet;
        block13: {
            bRet = false;
            InputStream is = null;
            try {
                try {
                    is = this.getContext().getAssets().open(fileName);
                    File file = new File(path);
                    file.createNewFile();
                    FileOutputStream fos = new FileOutputStream(file);
                    byte[] temp = new byte[1024];
                    int i = 0;
                    int fileLength = 0;
                    while ((i = is.read(temp)) > 0) {
                        fos.write(temp);
                        fileLength += i;
                    }
                    fos.close();
                    is.close();
                    bRet = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    bRet = false;
                    if (is == null) break block13;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bRet;
    }

    public void onDestroy() {
        try {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.receiver);
        }
        catch (Exception e) {
            Log.e((String)this.getTag(), (String)e.toString());
        }
        if (this.binder != null) {
            this.binder.onDestroy();
            this.binder = null;
        }
    }

    public void cancel() {
        if (this.handler != null) {
            this.handler.sendEmptyMessage(619068);
        }
    }
}

