/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.util;

import android.util.Log;
import java.io.FileWriter;
import java.io.IOException;

public class EpayLog {
    private static boolean saveLog = true;
    private static boolean showLog = false;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static String saveLogPath = "/sdcard/Platform-Log.txt";
    public static int mLogLevel = 2;
    public static String log_tag = "epay_log";
    private static FileWriter fWriter = null;

    public static void setShowLog(boolean bool) {
        showLog = bool;
    }

    public static void setLogLevel(int logLevel) {
        mLogLevel = logLevel;
    }

    public static int v(String tag, String msg) {
        if (mLogLevel <= 2) {
            return Log.v((String)log_tag, (String)msg);
        }
        return 0;
    }

    public static int d(String tag, String msg) {
        if (mLogLevel <= 3) {
            return Log.d((String)log_tag, (String)msg);
        }
        return 0;
    }

    public static int d(String tag, String msg, Throwable tr) {
        if (mLogLevel <= 3) {
            return Log.d((String)log_tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    public static int i(String tag, String msg) {
        if (mLogLevel <= 4) {
            return Log.i((String)log_tag, (String)msg);
        }
        return 0;
    }

    public static int w(String tag, String msg) {
        if (mLogLevel <= 5) {
            return Log.w((String)log_tag, (String)msg);
        }
        return 0;
    }

    public static int e(String tag, String msg) {
        if (mLogLevel <= 6) {
            return Log.e((String)tag, (String)msg);
        }
        return 0;
    }

    public static void saveLog(String str, String savePath, boolean append) {
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(savePath, append);
            if (fWriter != null) {
                fWriter.write(str);
                fWriter.flush();
                fWriter.close();
                fWriter = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void saveFile(String str, String savePath, boolean append) {
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(savePath, append);
            if (fWriter != null) {
                fWriter.write(str);
                fWriter.flush();
                fWriter.close();
                fWriter = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void showSaveLog(String tag, String msg) {
        EpayLog.v(tag, msg);
        if (saveLog) {
            try {
                if (fWriter == null) {
                    fWriter = new FileWriter(saveLogPath, true);
                }
                if (tag != null && msg != null) {
                    tag = String.valueOf(tag) + ":";
                    if (msg.length() >= 100) {
                        tag = String.valueOf(tag) + "\r\n";
                    }
                    fWriter.write(String.valueOf(tag) + msg + "\r\n");
                    fWriter.flush();
                }
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

