/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.util;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.android.easou.epay.sms.mms.pdu.EncodedStringValue;
import com.android.easou.epay.sms.mms.pdu.GenericPdu;
import com.android.easou.epay.sms.mms.pdu.MultimediaMessagePdu;
import com.android.easou.epay.sms.mms.pdu.PduBody;
import com.android.easou.epay.sms.mms.pdu.PduParser;
import com.android.easou.epay.sms.mms.pdu.PduPart;
import com.android.easou.epay.sms.mms.transaction.HttpUtils;
import com.android.easou.epay.util.EpayLog;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class MMSTools {
    public static String getAddressNumber(int id, Context context) {
        String selectionAdd = new String("msg_id=" + id);
        String uriStr = MessageFormat.format("content://mms/{0}/addr", id);
        Uri uriAddress = Uri.parse((String)uriStr);
        Cursor cAdd = context.getContentResolver().query(uriAddress, null, selectionAdd, null, null);
        String name = null;
        try {
            if (cAdd.moveToFirst()) {
                do {
                    String number;
                    if ((number = cAdd.getString(cAdd.getColumnIndex("address"))) == null) continue;
                    try {
                        Long.parseLong(number.replace("-", ""));
                        name = number;
                    }
                    catch (NumberFormatException nfe) {
                        if (name != null) continue;
                        name = number;
                    }
                } while (cAdd.moveToNext());
            }
            if (cAdd != null) {
                cAdd.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return name;
    }

    public static byte[] download(String contentLocation) {
        EpayLog.showSaveLog("===", "\u5f00\u59cb\u5f69\u4fe1\u4e0b\u8f7d");
        String mmsProxy = "10.0.0.172";
        int mmsProt = 80;
        String HDR_VALUE_ACCEPT_LANGUAGE = "UTF-8";
        String HDR_KEY_ACCEPT = "Accept";
        String HDR_KEY_ACCEPT_LANGUAGE = "Accept-Language";
        String HDR_VALUE_ACCEPT = "*/*, application/vnd.wap.mms-message, application/vnd.wap.sic";
        try {
            HttpHost httpHost = new HttpHost(mmsProxy, mmsProt);
            BasicHttpParams httpParams = new BasicHttpParams();
            httpParams.setParameter("http.route.default-proxy", (Object)httpHost);
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)10000);
            DefaultHttpClient client = new DefaultHttpClient((HttpParams)httpParams);
            HttpGet post = new HttpGet(contentLocation);
            post.addHeader("Accept", "*/*, application/vnd.wap.mms-message, application/vnd.wap.sic");
            post.addHeader("Accept-Language", HDR_VALUE_ACCEPT_LANGUAGE);
            post.addHeader("user-agent", "Mozilla/5.0(Linux;U;Android 2.1-update1;zh-cn;ZTE-C_N600/ZTE-C_N600V1.0.0B02;240*320;CTC/2.0)AppleWebkit/530.17(KHTML,like Gecko) Version/4.0 Mobile Safari/530.17");
            HttpParams params = client.getParams();
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            HttpResponse response = client.execute((HttpUriRequest)post);
            StatusLine status = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                byte[] pduByte;
                block8: {
                    InputStream input = entity.getContent();
                    DataInputStream inputData = new DataInputStream(input);
                    pduByte = new byte[(int)entity.getContentLength()];
                    try {
                        try {
                            inputData.readFully(pduByte);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            inputData.close();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        inputData.close();
                        throw throwable;
                    }
                    inputData.close();
                }
                EpayLog.showSaveLog("===", "\u5f69\u4fe1\u4e0b\u8f7d\u6570\u636e" + new String(pduByte));
                return pduByte;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            EpayLog.showSaveLog("====", "\u5f69\u4fe1\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public void getMMSContent(byte[] mmsData) throws UnsupportedEncodingException {
        GenericPdu pdu = new PduParser(mmsData).parse();
        if (pdu == null || pdu.getMessageType() != 132) {
            EpayLog.showSaveLog("xml", "\u6570\u636e\u4e3a\u7a7a\u6216\u7c7b\u578b\u9519\u8bef");
        } else if (pdu instanceof MultimediaMessagePdu) {
            PduBody body = ((MultimediaMessagePdu)pdu).getBody();
            String subject = ((MultimediaMessagePdu)pdu).getSubject().getString();
            if (body != null) {
                int partsNum = body.getPartsNum();
                int i = 0;
                while (i < partsNum) {
                    Bitmap bmp;
                    PduPart part = body.getPart(i);
                    String contentType = new String(part.getContentType(), "gb2312");
                    if (contentType.contains("text")) {
                        String string = new EncodedStringValue(part.getData()).getString();
                    } else if (contentType.contains("jpeg") && (bmp = BitmapFactory.decodeByteArray((byte[])part.getData(), (int)0, (int)part.getData().length)) == null) {
                        EpayLog.showSaveLog("xml", "Bitmap is null");
                    }
                    ++i;
                }
            }
        }
    }

    public static byte[] sendReportMMS(Context mContext, long token, String mmscUrl, byte[] pdu) {
        try {
            return HttpUtils.httpConnection(mContext, token, mmscUrl, pdu, 1, true, "10.0.0.172", 80);
        }
        catch (IOException e) {
            EpayLog.showSaveLog("", "\u53d1\u9001\u72b6\u6001\u62a5\u544a\u9519\u8bef\uff01" + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

