/*
 * Decompiled with CFR 0.152.
 */
package com.android.easou.epay.util;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.android.easou.epay.util.EpayLog;
import java.util.List;

public class WifiManage {
    private static final String LOG_TAG = WifiManage.class.getName();
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private List<ScanResult> mWifiList;
    private List<WifiConfiguration> mWifiConfiguration;
    WifiManager.WifiLock mWifiLock;

    public WifiManage(Context context) {
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
    }

    public void OpenWifi() {
        if (!this.mWifiManager.isWifiEnabled()) {
            this.mWifiManager.setWifiEnabled(true);
        }
    }

    public boolean isWifiManageEnable() {
        EpayLog.showSaveLog(LOG_TAG, "WIFImanageEnable is " + this.mWifiManager.isWifiEnabled());
        return this.mWifiManager.isWifiEnabled();
    }

    public void CloseWifi() {
        if (this.mWifiManager.isWifiEnabled()) {
            this.mWifiManager.setWifiEnabled(false);
        }
    }

    public void AcquireWifiLock() {
        this.mWifiLock.acquire();
    }

    public void ReleaseWifiLock() {
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.acquire();
        }
    }

    public void CreatWifiLock() {
        this.mWifiLock = this.mWifiManager.createWifiLock("Test");
    }

    public List<WifiConfiguration> GetConfiguration() {
        return this.mWifiConfiguration;
    }

    public void ConnectConfiguration(int index) {
        if (index > this.mWifiConfiguration.size()) {
            return;
        }
        this.mWifiManager.enableNetwork(this.mWifiConfiguration.get((int)index).networkId, true);
    }

    public void StartScan() {
        this.mWifiManager.startScan();
        this.mWifiList = this.mWifiManager.getScanResults();
        this.mWifiConfiguration = this.mWifiManager.getConfiguredNetworks();
    }

    public List<ScanResult> GetWifiList() {
        return this.mWifiList;
    }

    public StringBuilder LookUpScan() {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < this.mWifiList.size()) {
            stringBuilder.append("Index_" + new Integer(i + 1).toString() + ":");
            stringBuilder.append(this.mWifiList.get(i).toString());
            stringBuilder.append("\n");
            ++i;
        }
        return stringBuilder;
    }

    public String GetMacAddress() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getMacAddress();
    }

    public String GetBSSID() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getBSSID();
    }

    public int GetIPAddress() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getIpAddress();
    }

    public int GetNetworkId() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getNetworkId();
    }

    public String GetWifiInfo() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.toString();
    }

    public void AddNetwork(WifiConfiguration wcg) {
        int wcgID = this.mWifiManager.addNetwork(wcg);
        this.mWifiManager.enableNetwork(wcgID, true);
    }

    public void DisconnectWifi(int netId) {
        this.mWifiManager.disableNetwork(netId);
        this.mWifiManager.disconnect();
    }

    public static String getBt(Context context) {
        String bt = "";
        try {
            WifiManager wifi = (WifiManager)context.getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            String tmpbt = info.getMacAddress();
            int i = 0;
            while (i < tmpbt.length()) {
                char c = tmpbt.charAt(i);
                if (c != ':') {
                    bt = String.valueOf(bt) + c;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bt;
    }
}

