/*
 * Decompiled with CFR 0.152.
 */
package com.easou.epay_all.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.easou.epay_all.activity.CustomDialogActivity;
import com.easou.epay_all.all_pay.cmmpackage.CMMResult;
import com.easou.epay_all.all_pay.cmmpackage.CmmPackage;
import com.easou.epay_all.all_pay.cmmpackage.ParserUtil;
import com.easou.epay_all.all_pay.shenzhoupay.ShenzhouPay;
import com.easou.epay_all.all_pay.sms.SMSPay;
import com.easou.epay_all.all_pay.yibao.YeePay;
import com.easou.epay_all.db.SharePreferUtil;
import com.easou.epay_all.json.InitResponse;
import com.easou.epay_all.json.JSonParser;
import com.easou.epay_all.json.MsgResponse;
import com.easou.epay_all.json.PayParam;
import com.easou.epay_all.ui.FeeView;
import com.easou.epay_all.ui.LoadingView;
import com.easou.epay_all.util.ImageUtil;
import com.easou.epay_all.util.Lg;
import com.easou.epay_all.util.MyLog;
import com.easou.epay_all.util.SendSMS;
import com.easou.epay_all.util.SystemInfo;
import com.easou.epay_all.util.Tools;
import com.easou.epay_all.util.Util;
import com.hisun.b2c.api.core.IPOSUtils;
import com.unionpay.UPPayAssistEx;
import com.unionpay.uppay.PayActivity;
import java.io.StringReader;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.HttpEntity;

public class EasouPayActivity
extends CustomDialogActivity {
    private final int STATUS_PAY_NOT_STARTED = 0;
    private final int STATUS_PAYING = 1;
    private final int STATUS_PAY_FINISHED = 2;
    private final int STATUS_PAY_SUCC = 3;
    private final int STATUS_PAY_FAIL = 4;
    private final int STATUS_PAY_UNKNOW = 5;
    private final int STATUS_PAY_SHOWING_RESULT_WHEN_NET_ERROR = -1;
    private int mPayStatus = 0;
    private final String MSG = "msg";
    private FrameLayout rootView;
    public static LoadingView loadingView;
    public FeeView feeView;
    private Timer mTimer;
    private TimerTask mTimerTask;
    private String mFailMsg = null;
    public int cpidString;
    public int feeIdString;
    public int feeString;
    public String cpPrivateKeyString;
    public String cpOrderId;
    public String appName;
    protected static final String TAG;
    private IPOSUtils iposUtils;
    public MsgResponse response;
    public YeePay yeePay;
    public SMSPay smsPay;
    public ShenzhouPay shenzhouPay;

    static {
        TAG = null;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(0x1030010);
        this.setPayContentView();
        this.iposUtils = new IPOSUtils((Context)this);
        this.iposUtils.init();
        if (Util.isNetWorkConection((Context)this)) {
            this.init();
            this.submitEntren(String.valueOf(this.cpidString), String.valueOf(this.feeIdString), String.valueOf(this.feeString));
        } else {
            new AlertDialog.Builder((Context)this).setMessage((CharSequence)"\u8bf7\u8fde\u63a5\u7f51\u7edc\uff01").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    EasouPayActivity.this.setResult(6);
                    EasouPayActivity.this.finish();
                }
            }).show();
        }
    }

    private void getTradeInfo() {
        Intent intent = this.getIntent();
        if (intent.hasExtra("epay_appfee_id")) {
            this.feeIdString = intent.getIntExtra("epay_appfee_id", -1);
        }
        if (intent.hasExtra("epay_cpid")) {
            this.cpidString = intent.getIntExtra("epay_cpid", -1);
        }
        if (intent.hasExtra("epay_fee")) {
            this.feeString = intent.getIntExtra("epay_fee", -1);
        }
        if (intent.hasExtra("epay_cp_order_id")) {
            this.cpOrderId = intent.getStringExtra("epay_cp_order_id");
        }
        if (intent.hasExtra("epay_cp_private_key")) {
            this.cpPrivateKeyString = intent.getStringExtra("epay_cp_private_key");
        }
        if (intent.hasExtra("")) {
            this.appName = intent.getStringExtra("");
        }
    }

    private void init() {
        this.getTradeInfo();
    }

    private void setPayContentView() {
        this.getWindow().setBackgroundDrawable(ImageUtil.getDrawableFromAssetsFile("easou_pay_pic/no.png", (Context)this));
        this.rootView = new FrameLayout((Context)this);
        this.rootView.setBackgroundColor(Color.alpha((int)0));
        loadingView = new LoadingView((Context)this, null);
        this.rootView.addView((View)loadingView);
        this.feeView = new FeeView((Context)this, null);
        this.rootView.addView((View)this.feeView);
        this.feeView.setVisibility(8);
        this.setContentView((View)this.rootView);
    }

    private void hideLoadingView() {
        this.rootView.removeAllViews();
        this.rootView.invalidate();
    }

    public void showFeeView() {
        this.feeView.setVisibility(0);
        loadingView.setVisibility(8);
    }

    public void setTimerToNotifyPayFail() {
        this.cancelTimer();
        this.mTimerTask = new TimerTask(){

            @Override
            public void run() {
                EasouPayActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        EasouPayActivity.this.notifyPayResult(5, "\u652f\u4ed8\u6e20\u9053\u5546\u54cd\u5e94\u8d85\u65f6");
                    }
                });
            }
        };
        this.mTimer = new Timer();
        this.mTimer.schedule(this.mTimerTask, 5000L);
    }

    public void cancelTimer() {
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer.purge();
            this.mTimer = null;
        }
    }

    protected void onPayFinished(String rawUrl) {
    }

    private boolean canCloseWindow() {
        if (this.mPayStatus == 1) {
            this.showToast("\u6b63\u5728\u5904\u7406\u652f\u4ed8\u8bf7\u6c42\uff0c\u8bf7\u7a0d\u540e...");
            return false;
        }
        if (this.mPayStatus == 3) {
            this.notifyPayResult(999, "\u652f\u4ed8\u6210\u529f");
            return false;
        }
        if (this.mPayStatus == 4) {
            if (this.mFailMsg == null) {
                this.mFailMsg = "\u652f\u4ed8\u5931\u8d25";
            }
            this.notifyPayResult(6, this.mFailMsg);
            return false;
        }
        if (this.mPayStatus == 5 || this.mPayStatus == -1) {
            this.notifyPayResult(5, "\u652f\u4ed8\u6e20\u9053\u5546\u54cd\u5e94\u8d85\u65f6");
            return false;
        }
        return true;
    }

    @Override
    public void onCloseButtonClick() {
        if (!this.canCloseWindow()) {
            return;
        }
        this.confirmCancelPay();
    }

    public void onBackPressed() {
    }

    private void submitEntren(final String cpid, final String appFeeId, final String feeNum) {
        new AsyncTask<String, String, MsgResponse>(){

            protected MsgResponse doInBackground(String ... params) {
                this.doFirInit();
                return this.doEntren();
            }

            private void doFirInit() {
                String imsiFromDbString = SharePreferUtil.getLastIMSI((Context)EasouPayActivity.this).trim();
                String imsi = SystemInfo.getIMSI((Context)EasouPayActivity.this);
                if (imsiFromDbString == null || imsiFromDbString.equals("") || !imsiFromDbString.equals(imsi)) {
                    InitResponse reponseInitResponse = this.doInit(cpid);
                    if (reponseInitResponse.getResultCode().equals("0")) {
                        new SendSMS().sendSMS((Context)EasouPayActivity.this, reponseInitResponse.getSendMobile(), reponseInitResponse.getContent());
                    } else {
                        SharePreferUtil.setLastCallTime((Context)EasouPayActivity.this, reponseInitResponse.getMobileImsi());
                    }
                }
            }

            private MsgResponse doEntren() {
                String mess = null;
                HttpEntity entity = null;
                int i = 0;
                while (i < 3) {
                    String URL2 = String.format("http://epay.kdbooks.cn:8000/epayentrance?cpid=%s&appf_id=%s&paynum=%s", String.valueOf(cpid), String.valueOf(appFeeId), String.valueOf(feeNum));
                    try {
                        entity = Tools.getContent(URL2, Tools.getHeadersByDefault((Context)EasouPayActivity.this, Tools.sign(Tools.getSignType(), String.format("cpid=%s&appf_id=%s&paynum=%s", String.valueOf(cpid), String.valueOf(appFeeId), String.valueOf(feeNum)), EasouPayActivity.this.cpPrivateKeyString)), (Context)EasouPayActivity.this).getEntity();
                        if (entity != null) {
                            mess = Tools.getBody(entity);
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                Log.e((String)"===", (String)("\u8bf7\u6c42\u5b8c\u6210" + mess));
                EasouPayActivity.this.response = JSonParser.getMsgResponse(mess);
                System.out.println("response=" + EasouPayActivity.this.response);
                EasouPayActivity.this.response.setFeeString(EasouPayActivity.this.feeString);
                EasouPayActivity.this.response.setCpidString(cpid);
                EasouPayActivity.this.response.setAppName(EasouPayActivity.this.appName);
                return EasouPayActivity.this.response;
            }

            private InitResponse doInit(String cpid2) {
                String mess = null;
                HttpEntity entity = null;
                int i = 0;
                while (i < 3) {
                    String URL2 = "http://epay.kdbooks.cn:8000/epayinit";
                    try {
                        entity = Tools.getContent(URL2, Tools.getInitHeaders((Context)EasouPayActivity.this, cpid2), (Context)EasouPayActivity.this).getEntity();
                        if (entity != null) {
                            mess = Tools.getBody(entity);
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                Log.e((String)"===", (String)("\u8bf7\u6c42\u5b8c\u6210" + mess));
                InitResponse json = JSonParser.getInitResponse(mess);
                return json;
            }

            protected void onPostExecute(MsgResponse json) {
                super.onPostExecute((Object)json);
                if (json == null) {
                    EasouPayActivity.this.showToast("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
                    EasouPayActivity.this.finish();
                } else if (json.getResultCode().trim().equals("")) {
                    EasouPayActivity.this.showToast(json.getResultMsg());
                    EasouPayActivity.this.finish();
                } else if (json.getResultCode().trim().equals("2")) {
                    Toast.makeText((Context)EasouPayActivity.this, (CharSequence)json.getResultMsg(), (int)0).show();
                    EasouPayActivity.this.finish();
                } else if (json.getSmsPriority().trim().equals("1")) {
                    EasouPayActivity.this.smsPay = new SMSPay();
                    EasouPayActivity.this.smsPay.pay(EasouPayActivity.this, EasouPayActivity.this.response);
                    for (PayParam pam : EasouPayActivity.this.response.getList()) {
                        if (!pam.getGatewayCode().equals("callFee")) continue;
                        EasouPayActivity.this.submitOrder(pam.getGatewayId(), FeeView.PAYTYPE_SHOUJIHUAFEI);
                    }
                } else if (json.getSmsPriority().trim().equals("0")) {
                    EasouPayActivity.this.showFeeView();
                    EasouPayActivity.this.feeView.updateUI();
                }
            }
        }.execute((Object[])new String[]{""});
    }

    public void submitOrder(final String gateWayId, final int payType) {
        new AsyncTask<String, String, String>(){

            protected String doInBackground(String ... params) {
                this.doOrder();
                return null;
            }

            private void doOrder() {
                String mess = null;
                HttpEntity entity = null;
                int i = 0;
                while (i < 3) {
                    String URL2 = String.format("http://epay.kdbooks.cn:8000/epayorder?cpid=%s&appf_id=%s&paynum=%s&gateway_id=%s&cpOrderId=%s&orderId=%s", String.valueOf(EasouPayActivity.this.cpidString), String.valueOf(EasouPayActivity.this.feeIdString), String.valueOf(EasouPayActivity.this.feeString), String.valueOf(gateWayId), EasouPayActivity.this.cpOrderId, String.valueOf(EasouPayActivity.this.response.getResultMsg()));
                    try {
                        entity = Tools.getContent(URL2, Tools.getInitHeaders((Context)EasouPayActivity.this, EasouPayActivity.this.response.getCpidString()), (Context)EasouPayActivity.this).getEntity();
                        if (entity != null) {
                            mess = Tools.getBody(entity);
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++i;
                }
                if (!mess.equals("") && payType == FeeView.PAYTYPE_YINLIAN) {
                    String MODE_RELEASE;
                    String payMode = MODE_RELEASE = "00";
                    String tn = mess;
                    MyLog.e("===", "\u8fd4\u56detn=" + tn);
                    UPPayAssistEx.startPayByJAR((Activity)EasouPayActivity.this, PayActivity.class, null, null, (String)tn, (String)payMode);
                }
                Log.e((String)"===", (String)("\u8bf7\u6c42\u5b8c\u6210" + mess));
                InitResponse json = JSonParser.getInitResponse(mess);
            }

            protected void onPostExecute(String json) {
                super.onPostExecute((Object)json);
            }
        }.execute((Object[])new String[]{""});
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.e((String)"YeepayExampleActivity", (String)("requestCode=" + requestCode + "  resultCode=" + resultCode + " (data==null):" + (data == null)));
        System.out.println("================================" + data);
        data = this.getIntent();
        System.out.println("================================" + data);
        switch (requestCode) {
            case 1999: {
                this.yeePay.yibaoResult(requestCode, resultCode, data, this);
                break;
            }
            case 996: {
                System.out.println("\u624b\u673a\u8bdd\u8d39\u652f\u4ed8");
                this.smsPay.onSMSResult(resultCode, data);
                break;
            }
            case 1998: {
                this.shenzhouPay.onActivityResult(requestCode, resultCode, data);
                break;
            }
            case 10: {
                if (data == null) {
                    return;
                }
                String msg = "";
                String str = data.getExtras().getString("pay_result");
                if (str.equalsIgnoreCase("success")) {
                    this.notifyPayResult(999, "successs");
                    break;
                }
                if (str.equalsIgnoreCase("fail")) {
                    this.notifyPayResult(6, "failed");
                    break;
                }
                if (!str.equalsIgnoreCase("cancel")) break;
                this.notifyPayResult(6, "failed");
                break;
            }
        }
    }

    public void cmmPackagePay(final MsgResponse response) {
        Handler handler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                try {
                    switch (msg.what) {
                        case 622890: {
                            Lg.e("\u652f\u4ed8\u5b8c\u6210\uff1a\u4ee3\u7801\u4e3a\uff1a" + msg.what);
                            String strRet = (String)msg.obj;
                            Log.e((String)"", (String)(String.valueOf(strRet) + "\u8fd4\u56de\u6570\u636e"));
                            StringReader reader = new StringReader(strRet);
                            ParserUtil parserUtil = new ParserUtil();
                            CMMResult result = parserUtil.readXML(reader, (Context)EasouPayActivity.this);
                            Toast.makeText((Context)EasouPayActivity.this, (CharSequence)("\u652f\u4ed8\u5b8c\u6210\uff1a\u4ee3\u7801\u4e3a\uff1a" + msg.what), (int)1).show();
                            if (result != null && result.getOrder().equals(response.getResultCode()) && result.getResult_code().equals("0000")) {
                                EasouPayActivity.this.notifyPayResult(999, result.getResult_message());
                                break;
                            }
                            EasouPayActivity.this.notifyPayResult(4, result == null ? "\u652f\u4ed8\u5931\u8d25!" : result.getResult_message());
                            break;
                        }
                        case 619068: {
                            EasouPayActivity.this.notifyPayResult(4, "\u652f\u4ed8\u5931\u8d25!");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        CmmPackage.getInstance(this, response).pay(handler, this.iposUtils);
    }

    protected void onDestroy() {
        this.iposUtils.onDestroy();
        super.onDestroy();
    }
}

