/*
 * Decompiled with CFR 0.152.
 */
package com.easou.epay_all.all_pay.zhifubao;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.easou.epay_all.all_pay.zhifubao.FileFetch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

@SuppressLint(value={"HandlerLeak"})
public final class FileDownloader {
    private String fileUrl;
    private String savePath;
    private String tmpPath;
    private IDownloadProgress progressOutput;
    private FileFetch fetch;
    private boolean showProgress;

    public FileDownloader() {
        this.showProgress = false;
    }

    public FileDownloader(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public final void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public final void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    protected final boolean showProgress() {
        return this.showProgress;
    }

    public final void setSavePath(String savePath) {
        this.savePath = savePath;
        this.tmpPath = String.valueOf(savePath) + ".tmp";
    }

    public final void setProgressOutput(IDownloadProgress progressOutput) {
        if (progressOutput != null) {
            this.progressOutput = progressOutput;
        }
    }

    public void start() {
        final ProgressOutput output = new ProgressOutput(Looper.getMainLooper());
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileDownloader.this.fetch = new FileFetch(FileDownloader.this.fileUrl, FileDownloader.this.savePath, FileDownloader.this);
                long fileLen = -1L;
                if (FileDownloader.this.showProgress) {
                    fileLen = FileDownloader.this.getFileSize();
                    if (fileLen <= 0L) {
                        output.sendEmptyMessage(0);
                        return;
                    }
                } else {
                    FileDownloader.this.deleteFile();
                }
                if (FileDownloader.this.showProgress) {
                    FileDownloader.this.readTempFile();
                    if (FileDownloader.this.fetch.getFileEnd() != fileLen) {
                        FileDownloader.this.deleteFile();
                        FileDownloader.this.fetch.setFileStart(0L);
                        FileDownloader.this.fetch.setFileEnd(fileLen);
                    }
                }
                new Thread(FileDownloader.this.fetch).start();
                output.isFinished = false;
                while (!FileDownloader.this.fetch.isStop()) {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    output.sendEmptyMessage(0);
                }
                output.sendEmptyMessage(0);
            }
        }).start();
    }

    public void stop() {
        this.fetch.stop();
    }

    private long getFileSize() {
        long fileLength = -1L;
        try {
            HttpEntity entity = FileDownloader.getHttpEntity(this.fileUrl, false);
            fileLength = entity.getContentLength();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileLength;
    }

    private void deleteFile() {
        File file = new File(this.savePath);
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(this.tmpPath)).exists()) {
            file.delete();
        }
    }

    protected void writeTempFile() {
        FileOutputStream out = null;
        ObjectOutputStream objOut = null;
        try {
            try {
                out = new FileOutputStream(this.tmpPath);
                objOut = new ObjectOutputStream(out);
                objOut.writeLong(this.fetch.getFileStart());
                objOut.writeLong(this.fetch.getFileEnd());
                objOut.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    objOut.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                objOut.close();
            }
            catch (Exception exception) {}
        }
    }

    private void readTempFile() {
        FileInputStream in = null;
        ObjectInputStream objIn = null;
        try {
            try {
                in = new FileInputStream(this.tmpPath);
                objIn = new ObjectInputStream(in);
                this.fetch.setFileStart(objIn.readLong());
                this.fetch.setFileEnd(objIn.readLong());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    objIn.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                objIn.close();
            }
            catch (Exception exception) {}
        }
    }

    public static HttpEntity getHttpEntity(String netAddress, boolean isZip) throws Exception {
        try {
            HttpResponse response;
            int code;
            HttpGet httpGet = new HttpGet(netAddress);
            DefaultHttpClient httpClient = new DefaultHttpClient();
            if (isZip) {
                httpGet.addHeader("Accept-Encoding", "gzip");
            }
            if ((code = (response = httpClient.execute((HttpUriRequest)httpGet)).getStatusLine().getStatusCode()) == 200) {
                HttpEntity entity = response.getEntity();
                return entity;
            }
            throw new Exception("net work exception,ErrorCode :" + code);
        }
        catch (SSLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static interface IDownloadProgress {
        public void downloadProgress(float var1);

        public void downloadSucess();

        public void downloadFail();
    }

    private class ProgressOutput
    extends Handler {
        private boolean isFinished;

        @SuppressLint(value={"HandlerLeak"})
        public ProgressOutput(Looper looper) {
            super(looper);
            this.isFinished = false;
        }

        public void handleMessage(Message msg) {
            if (FileDownloader.this.progressOutput == null) {
                return;
            }
            if (FileDownloader.this.progressOutput == null) {
                return;
            }
            try {
                float progress = 50.0f;
                if (FileDownloader.this.showProgress) {
                    progress = FileDownloader.this.fetch.getFileStart() * 100L / FileDownloader.this.fetch.getFileEnd();
                } else if (FileDownloader.this.fetch.isStop()) {
                    progress = 100.0f;
                }
                if (FileDownloader.this.fetch.isStop()) {
                    if (progress == 100.0f && !this.isFinished) {
                        FileDownloader.this.progressOutput.downloadSucess();
                        this.isFinished = true;
                    } else if (progress > 100.0f) {
                        FileDownloader.this.deleteFile();
                        FileDownloader.this.progressOutput.downloadFail();
                    } else if (!this.isFinished) {
                        FileDownloader.this.progressOutput.downloadFail();
                    }
                } else {
                    FileDownloader.this.progressOutput.downloadProgress(progress);
                }
            }
            catch (Exception e) {
                FileDownloader.this.progressOutput.downloadFail();
            }
        }
    }
}

