/*
 * Decompiled with CFR 0.152.
 */
package com.easou.epay_all.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.easou.epay_all.util.Lg;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemInfo {
    public static String LOG_TAG = "platform";
    public static final String NETWORK_TYPE_GPRS_WAP = "gprs-wap";
    public static final String NETWORK_TYPE_EDGE_WAP = "edge-wap";
    public static final String NETWORK_TYPE_3G_WAP = "3g-wap";
    public static final String NETWORK_TYPE_3G_NET = "3g-net";
    public static final String NETWORK_TYPE_GPRS_NET = "gprs-net";
    public static final String NETWORK_TYPE_EDGE_NET = "edge-net";
    public static final String NETWORK_TYPE_WIFI = "wifi";
    public static final String UNKNOW = "unknow";
    public static final String CHINA_MOBILE = "mobile";
    public static final String CHINA_UNICOM = "unicom";
    public static final String CHINA_TELECOM = "telecom";
    private static String imsi;
    private static String imei;
    private static String smsc;
    private static boolean startService;
    private static boolean hasSuperAction;
    private static String screen;
    private static int mScreenWidthPixels;
    private static int mScreenHeightPixels;
    private static String mNetworkInfo;
    private static String mid;
    private static String midx;
    private static String lac;
    private static String bt;
    public static String cardType;
    private static int simState;
    private static int cpId;
    private static int serviceId;
    private static int fee;
    private static String p;

    static {
        smsc = "00000000000";
        mNetworkInfo = UNKNOW;
        cpId = -1;
        serviceId = -1;
        fee = -1;
        p = "";
    }

    private static void _getNetworkInfo(Context context) {
        ConnectivityManager conManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo network = conManager.getActiveNetworkInfo();
        mNetworkInfo = UNKNOW;
        if (network != null) {
            switch (network.getType()) {
                case 0: {
                    TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                    int type = tm.getNetworkType();
                    Proxy waptype = SystemInfo.getProxy(context);
                    if (type == 1) {
                        if (waptype != null) {
                            mNetworkInfo = NETWORK_TYPE_GPRS_WAP;
                            break;
                        }
                        mNetworkInfo = NETWORK_TYPE_GPRS_NET;
                        break;
                    }
                    if (type == 2 || type == 0) {
                        if (waptype != null) {
                            mNetworkInfo = NETWORK_TYPE_EDGE_WAP;
                            break;
                        }
                        mNetworkInfo = NETWORK_TYPE_EDGE_NET;
                        break;
                    }
                    if (waptype != null) {
                        mNetworkInfo = NETWORK_TYPE_3G_WAP;
                        break;
                    }
                    mNetworkInfo = NETWORK_TYPE_3G_NET;
                    break;
                }
                case 1: {
                    mNetworkInfo = NETWORK_TYPE_WIFI;
                    break;
                }
                default: {
                    mNetworkInfo = UNKNOW;
                }
            }
        }
    }

    public static String getIMSI(Context context) {
        if (imsi != null) {
            return imsi;
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        imsi = tm.getSubscriberId();
        if (imsi == null) {
            imsi = "";
        }
        return imsi;
    }

    public static void updateIMSI(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        imsi = tm.getSubscriberId();
        if (imsi != null) {
            cardType = imsi.startsWith("46000") || imsi.startsWith("46002") || imsi.startsWith("46007") ? CHINA_MOBILE : (imsi.startsWith("46001") ? CHINA_UNICOM : (imsi.startsWith("46003") ? CHINA_TELECOM : UNKNOW));
        } else {
            imsi = "";
            cardType = "unknown";
        }
    }

    public static String getIMEI(Context context) {
        if (imei != null) {
            return imei;
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        imei = tm.getDeviceId();
        if (imei == null) {
            imei = "";
        }
        return imei;
    }

    public static String getSMSC() {
        return smsc;
    }

    public static void setSMSC(Context context, String number) {
        if (number != null && !number.trim().equals("") && number.length() == 11) {
            smsc = number;
            midx = mid = String.valueOf(SystemInfo.getSMSC()) + '#' + SystemInfo.getIMSI(context);
        }
    }

    public static String getMID(Context context) {
        if (mid != null) {
            return mid;
        }
        midx = mid = String.valueOf(SystemInfo.getSMSC()) + '#' + SystemInfo.getIMSI(context);
        return mid;
    }

    public static String getMIDX(Context context) {
        if (midx != null) {
            return midx;
        }
        midx = SystemInfo.getMID(context);
        return midx;
    }

    public static String getLAC(Context context) {
        if (lac != null) {
            return lac;
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        GsmCellLocation gsmCellLocation = (GsmCellLocation)tm.getCellLocation();
        if (gsmCellLocation != null) {
            int lac1 = gsmCellLocation.getLac();
            int lac2 = gsmCellLocation.getCid();
            if (lac1 != -1) {
                lac = "" + lac1;
                if (lac2 != -1) {
                    lac = String.valueOf(lac) + "#" + lac2;
                }
            }
        }
        if (lac == null) {
            lac = "0000#00";
        }
        return lac;
    }

    public static String getBT(Context context) {
        String tmpbt;
        if (bt != null) {
            return bt;
        }
        WifiManager wifi = (WifiManager)context.getSystemService(NETWORK_TYPE_WIFI);
        WifiInfo info = wifi.getConnectionInfo();
        if (info != null && (tmpbt = info.getMacAddress()) != null) {
            bt = "";
            int i = 0;
            while (i < tmpbt.length()) {
                char c = tmpbt.charAt(i);
                if (c != ':') {
                    bt = String.valueOf(bt) + c;
                }
                ++i;
            }
        }
        return bt;
    }

    public static int getScreenWidth(Context context) {
        if (mScreenWidthPixels > 0) {
            return mScreenWidthPixels;
        }
        SystemInfo.setScreenInfomation(context);
        return mScreenWidthPixels;
    }

    public static int getScreenHeight(Context context) {
        if (mScreenHeightPixels > 0) {
            return mScreenHeightPixels;
        }
        SystemInfo.setScreenInfomation(context);
        return mScreenHeightPixels;
    }

    public static String getScreen(Context context) {
        if (screen != null) {
            return screen;
        }
        screen = String.valueOf(SystemInfo.getScreenWidth(context)) + "x" + SystemInfo.getScreenHeight(context);
        return screen;
    }

    private static void setScreenInfomation(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(dm);
        mScreenHeightPixels = dm.heightPixels;
        mScreenWidthPixels = dm.widthPixels;
    }

    public static String getCardType(Context context) {
        try {
            String imsi = SystemInfo.getIMSI(context);
            Lg.e("==", "imsi" + imsi);
            cardType = imsi != null ? (imsi.startsWith("46000") || imsi.startsWith("46002") || imsi.startsWith("46007") ? CHINA_MOBILE : (imsi.startsWith("46001") ? CHINA_UNICOM : (imsi.startsWith("46003") ? CHINA_TELECOM : UNKNOW))) : UNKNOW;
        }
        catch (Exception e) {
            cardType = UNKNOW;
        }
        return cardType;
    }

    public static String getNetworkInfo(Context context) {
        SystemInfo._getNetworkInfo(context);
        return mNetworkInfo;
    }

    public static Proxy getProxy(Context context) {
        block4: {
            ConnectivityManager conManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo network = conManager.getActiveNetworkInfo();
            if (network == null || network.getType() != 1) break block4;
            return null;
        }
        try {
            String proxyHost = android.net.Proxy.getDefaultHost();
            if (proxyHost != null && !proxyHost.equals("")) {
                Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(android.net.Proxy.getDefaultHost(), android.net.Proxy.getDefaultPort()));
                return p;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static int getSimState(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            simState = tm.getSimState();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return simState;
    }

    public static boolean isStartService() {
        return startService;
    }

    public static void setStartServiceState(boolean state) {
        startService = state;
    }

    public static boolean hasSuperAction() {
        return hasSuperAction;
    }

    public static void setHasSuperAction(boolean state) {
        hasSuperAction = state;
    }

    public static void setCpId(int cpId) {
        SystemInfo.cpId = cpId;
    }

    public static void setServiceId(int serviceId) {
        SystemInfo.serviceId = serviceId;
    }

    public static void setFee(int fee) {
        SystemInfo.fee = fee;
    }

    public static String getPackageName(Context context) {
        if (context == null) {
            return null;
        }
        String packateName = context.getPackageName();
        Lg.e("", "\u5305\u540d\u4e3a" + packateName);
        return packateName;
    }

    public static String getNativePhoneNumber(Context context) {
        String NativePhoneNumber = null;
        NativePhoneNumber = ((TelephonyManager)context.getSystemService("phone")).getLine1Number();
        return NativePhoneNumber;
    }

    public static boolean isMobileNO(String mobiles) {
        if (mobiles == null || mobiles.trim().equals("")) {
            return false;
        }
        Pattern p = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0-9]))\\d{8}$");
        Matcher m = p.matcher(mobiles);
        Lg.e("", "\u8f93\u5165\u7684\u7535\u8bdd\u53f7\u7801\u662f " + mobiles + " ,,," + m.matches());
        return m.matches();
    }

    private static int getIntRandom(int start, int end) {
        return (int)(Math.random() * (double)(end - start + 1)) + start;
    }

    public static String getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HHmmssSSS");
        return String.valueOf(dateFormat.format(Calendar.getInstance().getTime())) + SystemInfo.getIntRandom(100, 999);
    }

    private static String judgeUserImsi(Context context, String userString) {
        if (userString.contains(SystemInfo.getIMSI(context))) {
            return userString.substring(userString.indexOf("-") + 1);
        }
        return null;
    }

    public static boolean isPhoneNumberValid(String mobiles) {
        if (mobiles == null || mobiles.trim().equals("")) {
            return false;
        }
        if (mobiles.startsWith("+86")) {
            mobiles = mobiles.substring(3);
        }
        if (mobiles.length() != 11) {
            return false;
        }
        Pattern p = Pattern.compile("^([1][3-9])\\d{9}$");
        Matcher m = p.matcher(mobiles);
        return m.matches();
    }

    public static boolean isAllNumberString(String str, Integer minNum, Integer maxNum) {
        if (str == null || str.trim().equals("")) {
            return false;
        }
        if (minNum == null) {
            minNum = 0;
        }
        String patternStr = "\\d{" + minNum + ",";
        if (maxNum != null) {
            patternStr = String.valueOf(patternStr) + maxNum;
        }
        patternStr = String.valueOf(patternStr) + "}";
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(str);
        return m.matches();
    }
}

