/*
 * Decompiled with CFR 0.152.
 */
package com.easou.epay_all.util;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import android.widget.Toast;

public class Util {
    public static int getDisplayMetricsWidth(Activity activity) {
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        return dm.widthPixels;
    }

    public static int getDisplayMetricsHeight(Activity activity) {
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels;
    }

    public static float getScreenDensity(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(dm);
        float screenDensity = dm.density;
        Log.v((String)"====", (String)("==" + screenDensity));
        return screenDensity;
    }

    public static void startPhone(Context context, String phoneNumber) {
        try {
            Intent dial = new Intent();
            dial.setAction("android.intent.action.DIAL");
            dial.setData(Uri.parse((String)("tel:" + phoneNumber)));
            context.startActivity(dial);
        }
        catch (Exception ex) {
            Toast.makeText((Context)context, (CharSequence)"Sorry, we couldn't find any app to place a phone call!", (int)0).show();
        }
    }

    public static void startSmsIntent(Context context, String phoneNumber) {
        try {
            Uri uri = Uri.parse((String)("sms:" + phoneNumber));
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.putExtra("address", phoneNumber);
            intent.setType("vnd.android-dir/mms-sms");
            context.startActivity(intent);
        }
        catch (Exception ex) {
            Toast.makeText((Context)context, (CharSequence)"Sorry, we couldn't find any app to send an SMS!", (int)0).show();
        }
    }

    public static void startEmailIntent(Context context, String emailAddress) {
        try {
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType("plain/text");
            intent.putExtra("android.intent.extra.EMAIL", new String[]{emailAddress});
            context.startActivity(intent);
        }
        catch (Exception ex) {
            Toast.makeText((Context)context, (CharSequence)"Sorry, we couldn't find any app for sending emails!", (int)0).show();
        }
    }

    public static void startWebIntent(Context context, String url) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            context.startActivity(intent);
        }
        catch (Exception ex) {
            Toast.makeText((Context)context, (CharSequence)"Sorry, we couldn't find any app for viewing this url!", (int)0).show();
        }
    }

    private static boolean SdcardIsExist() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getVersionName(Context context, String packageName) {
        String versionName = "";
        try {
            versionName = context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionName;
    }

    public static int getVersionCode(Context context, String packageName) {
        int verCode = -1;
        try {
            verCode = context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return verCode;
    }

    public static void showToastLong(Context context, String string) {
        Toast.makeText((Context)context, (CharSequence)string, (int)1).show();
    }

    public static void showToastShort(Context context, String string) {
        Toast.makeText((Context)context, (CharSequence)string, (int)0).show();
    }

    public static boolean isNetWorkConection(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable();
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = cm.getNetworkInfo(1);
        return ni.getState() == NetworkInfo.State.CONNECTED;
    }

    public static boolean isWapConnected(Context context) {
        if (Util.isWifiConnected(context)) {
            return false;
        }
        Uri contentUri = Uri.parse((String)"content://telephony/carriers/preferapn");
        Cursor cursor = null;
        ContentResolver resolver = context.getContentResolver();
        cursor = resolver.query(contentUri, new String[]{"proxy", "port"}, null, null, null);
        if (cursor != null) {
            String proxy = null;
            int port = 0;
            if (cursor.moveToFirst()) {
                proxy = cursor.getString(0);
                String strPort = cursor.getString(1);
                if (strPort != null && strPort.length() > 0) {
                    port = Integer.valueOf(strPort);
                }
            }
            if (!TextUtils.isEmpty(proxy)) {
                if (port <= 0) {
                    port = 80;
                }
                return true;
            }
        }
        return false;
    }
}

