/*
 * Decompiled with CFR 0.152.
 */
package com.easou.epay_all.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.util.Log;
import com.easou.epay_all.all_pay.zhifubao.Rsa;
import com.easou.epay_all.util.Lg;
import com.easou.epay_all.util.SystemInfo;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class Tools {
    private static boolean saveLog = true;
    private static boolean showLog = true;
    private static FileWriter fWriter = null;
    private static String saveLogPath = "/sdcard/Platform-Log.txt";
    private static final String SMSCountShare = "SMSCountShare";
    private static final String MONTH = "month";
    private static final String COUNT = "count";

    public static void setShowLog(boolean bool) {
        showLog = bool;
    }

    public static void showLog(String tag, String msg) {
        if (showLog) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void showSaveLog(String tag, String msg) {
        if (showLog) {
            Log.e((String)tag, (String)msg);
        }
        if (saveLog) {
            try {
                if (fWriter == null) {
                    fWriter = new FileWriter(saveLogPath, true);
                }
                if (tag != null && msg != null) {
                    tag = String.valueOf(tag) + ":";
                    if (msg.length() >= 100) {
                        tag = String.valueOf(tag) + "\r\n";
                    }
                    fWriter.write(String.valueOf(tag) + msg + "\r\n");
                    fWriter.flush();
                }
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeSaveLog() {
        try {
            if (fWriter != null) {
                fWriter.close();
                fWriter = null;
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isAppInstalled(Context context, String packageName) {
        if (packageName == null || packageName.trim().equals("")) {
            return false;
        }
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(packageName, 8192);
            return info != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static void saveLog(String str, String savePath, boolean append) {
        if (saveLog) {
            FileWriter fWriter = null;
            try {
                fWriter = new FileWriter(savePath, append);
                if (fWriter != null) {
                    fWriter.write(str);
                    fWriter.flush();
                    fWriter.close();
                    fWriter = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void saveFile(String str, String savePath, boolean append) {
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(savePath, append);
            if (fWriter != null) {
                fWriter.write(str);
                fWriter.flush();
                fWriter.close();
                fWriter = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        int i = 0;
        while (i < len) {
            int pos = i * 2;
            result[i] = (byte)(Tools.toByte(achar[pos]) << 4 | Tools.toByte(achar[pos + 1]));
            ++i;
        }
        return result;
    }

    private static byte toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    private static final String bytesToHexString(byte[] bArray) {
        if (bArray == null) {
            return null;
        }
        if (bArray.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bArray.length * 2);
        int i = 0;
        while (i < bArray.length) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public static final String toHex(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        return Tools.bytesToHexString(str.getBytes());
    }

    public static final String fromHex(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        return new String(Tools.hexStringToByte(str));
    }

    public static final String fromHex(String str, String charset) {
        if (str == null || str.equals("")) {
            return str;
        }
        try {
            return new String(Tools.hexStringToByte(str), charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(Tools.hexStringToByte(str));
        }
    }

    public static void printStackTrace(String log_tag, StackTraceElement[] stack) {
        StackTraceElement[] stackTraceElementArray = stack;
        int n = stack.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            Log.e((String)log_tag, (String)("\tat " + element));
            ++n2;
        }
    }

    public static List<String> getStringFromHeader(InputStream header) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(header));
        String tem = null;
        try {
            while ((tem = br.readLine()) != null) {
                list.add(Tools.fromHex(tem));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void updateSMSCount(Context context) {
        int count = 0;
        SharedPreferences pre = context.getSharedPreferences(SMSCountShare, 2);
        SharedPreferences.Editor edit = pre.edit();
        String lastMonth = pre.getString(MONTH, null);
        String thisMonth = Tools.getCurrentDate("yyyy-MM", null);
        if (lastMonth != null && lastMonth.equals(lastMonth)) {
            count = pre.getInt(COUNT, 0) + 1;
            edit.putInt(COUNT, count);
        } else {
            edit.putString(MONTH, thisMonth);
            edit.putInt(COUNT, ++count);
        }
        Log.e((String)"cont", (String)("count is " + count + ", month is " + thisMonth));
        edit.commit();
    }

    public static int getSMSCount(Context context) {
        SharedPreferences pre = context.getSharedPreferences(SMSCountShare, 2);
        int count = pre.getInt(COUNT, 0);
        return count;
    }

    public static String getSubString(String str, int length) {
        if (str == null || length < 0 || str.length() <= length) {
            return str;
        }
        return str.substring(0, length);
    }

    public static String getHeader(HttpResponse response) {
        String header = null;
        if (response != null) {
            Header[] headers = response.getAllHeaders();
            StringBuffer sb = new StringBuffer();
            Header[] headerArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                Header tem = headerArray[n2];
                sb.append(tem + "\r\n");
                ++n2;
            }
            header = sb.toString();
        }
        return header;
    }

    public static String getBody(HttpEntity entity) {
        try {
            Lg.e("====", "\u5904\u7406entit" + entity);
            Lg.e("====", String.valueOf(entity.getContentLength()));
            String result = EntityUtils.toString((HttpEntity)entity);
            return result;
        }
        catch (Exception e) {
            Lg.e("====", "\u5904\u7406entity\u9519\u8bef" + entity + " , " + e.getMessage() + " , " + e.getStackTrace());
            return null;
        }
    }

    public static byte[] readFile(String path) {
        byte[] data = null;
        try {
            FileInputStream fin = new FileInputStream(path);
            int length = fin.available();
            if (length > 0) {
                data = new byte[length];
                int k = 1024;
                int start = 0;
                while (start < length) {
                    k = length - start;
                    if (k >= 1024) {
                        k = 1024;
                    }
                    fin.read(data, start, k);
                    start += k;
                }
            }
            fin.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data;
    }

    public static String replaceSpecialChar(String str) {
        if (str == null || str.trim().equals("")) {
            return str;
        }
        String[] source = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;", "&nbsp;"};
        String[] replace = new String[]{"<", ">", "&", "'", "\"", " "};
        int i = 0;
        while (i < source.length) {
            str = str.replaceAll(source[i], replace[i]);
            ++i;
        }
        return str;
    }

    public static String subString(String source, String start, Integer startInc, String end, Integer endInc) {
        String result = null;
        if (source == null || start == null || end == null) {
            return result;
        }
        if (startInc == null) {
            startInc = start.length();
        }
        if (endInc == null) {
            endInc = end.length();
        }
        int index1 = source.indexOf(start);
        int index2 = 0;
        if (index1 >= 0) {
            index2 = source.indexOf(end, index1 += startInc.intValue());
            int length = source.length();
            if (index1 >= 0 && (index2 += endInc.intValue()) <= length && index2 > index1) {
                result = source.substring(index1, index2);
            } else if (index1 == index2) {
                result = "";
            }
        }
        return result;
    }

    public static String replaceAll(String source, String subStr, String newStr) {
        if (source == null || source.equals("") || subStr == null || subStr.equals("")) {
            return source;
        }
        int begin = 0;
        int index = source.indexOf(subStr, begin);
        while (index >= 0) {
            source = String.valueOf(source.substring(0, index)) + newStr + source.substring(index + subStr.length());
            index = source.indexOf(subStr);
        }
        return source;
    }

    public static String getCurrentDate(String format, Date date) {
        if (format == null) {
            format = "yyyy-MM-dd";
        }
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static HttpResponse getContent(String url, Header[] headers, Context context) {
        HttpResponse rsp = null;
        try {
            Lg.e("====", "\u7f51\u7edc\u8bf7\u6c42\u5730\u5740\uff1a " + url);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet req = new HttpGet(url);
            if (Tools.isNeedProxy(context)) {
                HttpHost proxy = new HttpHost(Proxy.getDefaultHost(), Proxy.getDefaultPort(), "http");
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                req.setHeader("accept", "text/vnd.wap.wml");
            }
            Lg.e("====", "\u7f51\u7edc\u8bf7\u6c42\u5730\u5740\uff1a00\uff01");
            if (headers != null) {
                req.setHeaders(headers);
            }
            rsp = httpclient.execute((HttpUriRequest)req);
            Lg.e("====", "\u7f51\u7edc\u8bf7\u6c42\u5730\u5740\uff1a11\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            Lg.e("===", String.valueOf(e.getMessage()) + "\u83b7\u53d6\u534f\u8bae\u5f02\u5e38\uff01");
        }
        Lg.e("====", "\u7f51\u7edc\u8bf7\u6c42\u5730\u5740\uff1a\u7ed3\u675f\uff01");
        return rsp;
    }

    public static boolean isNeedProxy(Context context) {
        block4: {
            ConnectivityManager conManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo network = conManager.getActiveNetworkInfo();
            if (network == null || network.getType() != 1) break block4;
            return false;
        }
        try {
            String proxyHost = Proxy.getDefaultHost();
            if (proxyHost != null && !proxyHost.equals("")) {
                Lg.e("info", "\u4f7f\u7528\u4ee3\u7406");
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getConfirmURL(Context context, int whichOne, int confirmOrCancle) {
        return null;
    }

    public static Header[] getHeadersByDefault(Context context, String sign) {
        Header[] headers = new Header[3];
        BasicHeader mobile_model = new BasicHeader("mobileImsi", SystemInfo.getIMSI(context));
        headers[0] = mobile_model;
        BasicHeader sinHeader = new BasicHeader("sign", sign);
        headers[1] = sinHeader;
        BasicHeader sdkVersion = new BasicHeader("sdkVersion", "1.1");
        headers[2] = sdkVersion;
        return headers;
    }

    public static Header[] getInitHeaders(Context context, String cpid) {
        Header[] headers = new Header[5];
        BasicHeader mobile_model = new BasicHeader("mobileImsi", SystemInfo.getIMSI(context));
        headers[0] = mobile_model;
        BasicHeader modelHeader = new BasicHeader("mobileModel", "");
        headers[1] = modelHeader;
        BasicHeader osHeader = new BasicHeader("osVersion", "");
        headers[2] = osHeader;
        BasicHeader netModelHeader = new BasicHeader("netMode", "");
        headers[3] = netModelHeader;
        BasicHeader cpidHeader = new BasicHeader("cp", cpid);
        headers[4] = cpidHeader;
        return headers;
    }

    public static String getStringFromInputStream(InputStream input) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String tem = null;
        StringBuffer sb = new StringBuffer();
        try {
            while ((tem = reader.readLine()) != null) {
                sb.append(tem);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Lg.e("===", "\u534f\u8bae\u6570\u636e\u4e3a\uff1a" + sb.toString());
        return sb.toString();
    }

    public static String sign(String signType, String content, String priKey) {
        return Rsa.sign(content, priKey);
    }

    public static String getSignType() {
        String getSignType = "sign_type=\"RSA\"";
        return getSignType;
    }

    public static String getCharset() {
        String charset = "charset=\"utf-8\"";
        return charset;
    }
}

